var ngAdSense = angular.module('ngAdsense', []);
ngAdSense.constant('SCRIPT_URL', '//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js');
/**
 * This directive is necessary for keeping track of Google Ads <script> creation.
 * Creating it twice will result in ads returning a 400 error
 * @directive
 * @since 1.1
 */
ngAdSense.service("AdsenseTracker", [function()
{
    this.isLoaded = false;
}]);
/**
 * This controller is necessary for handling the DOM manipulation.
 * @controller
 * @since 1.0
 */
ngAdSense.controller('AdsenseController', ["SCRIPT_URL", "AdsenseTracker", function(SCRIPT_URL, AdsenseTracker) {

    if (!AdsenseTracker.isLoaded)
    {
        var s = document.createElement('script');
        s.src = SCRIPT_URL;
        document.body.appendChild(s);
        AdsenseTracker.isLoaded = true;
    }
	angular.element(document).ready(function () {(window.adsbygoogle = window.adsbygoogle || []).push({})});
}]);
/**
 * @directive adsenseDirective
 * @cfg adClient AdSense Client id. (Mandatory field)
 * @cfg adSlot AdSense Slot id. (Mandatory field)
 * @cfg cssStyle CSS customization generated by AdSense website. (Mandatory field)
 */
ngAdSense.directive('adsenseDirective', function() {
    return {
        restrict : 'E',
        replace : true,
        template : '<div><ins class="adsbygoogle" data-ad-client="'+plugins['adsMobile']['adClient']+'" data-ad-slot="'+plugins['adsMobile']['adSlot']+'" data-ad-format="fluid"></ins></div>',
        controller : 'AdsenseController'
    };
});
